import argparse
import csv
import json

def handle_file(csv_path,json_path,indent):
    with open(csv_path,'r') as f:
        reader = csv.DictReader(f)
        data = list(reader)
    
    with open(json_path,'w') as f:
        json.dump(data,f,indent = indent)

parser = argparse.ArgumentParser(description="My File Parser")
parser.add_argument("csv_path",help="Path to the CSV file")
parser.add_argument("json_path",help="Path to the JSON file")
parser.add_argument("--indent",help="Indentation for JSON file",default=4,type=int)
args = parser.parse_args()
handle_file(args.csv_path , args.json_path,args.indent)